﻿using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VA.TMP.OptionSets;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Create Patient Veteran Identifier step.
    /// </summary>
    public class CreatePatientVeteranIdentifierStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            if (string.IsNullOrEmpty(state.PatientSite) || state.Veteran == null) return;

            // Query to determine if the Patient Site is already in the Identifier list
            var veteranIdentifier = state.VeteranIdentifiers.FirstOrDefault(x => x.mcs_assigningfacility == state.PatientSite);

            if (veteranIdentifier == null)
            {
                state.PatientSideIdentifierToAdd = new mcs_personidentifiers()
                {
                    mcs_assigningauthority = "USVHA",
                    mcs_assigningfacility = state.PatientSite,
                    mcs_identifier = "PROXY_VISTA",
                    mcs_identifiertype = new Microsoft.Xrm.Sdk.OptionSetValue((int)mcs_personidentifiersmcs_identifiertype.ParticipantIdentifier_PI),
                    mcs_name = string.Format("VistA Station {0} IEN", state.PatientSite),
                    mcs_patient = new Microsoft.Xrm.Sdk.EntityReference(Contact.EntityLogicalName, state.Veteran.Id)
                };
            }
            else
            {
                Logger.Instance.Debug("Patient Site already in the Identifer list");
            }
        }
    }
}